/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.cim.client.HSCSendSignalClt;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.HscPasswordMgr;
import com.ibm.hsc.common.util.PIHscUtil;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMValue;

public class PIRemoveSystemConnection {
    private static final int NUM_VALID_PARMS = 4;
    private PrintStream _out;
    private boolean _writeStatus;
    private HashMap _validParms;
    private String _ipAddress;
    private String _managedSystem;
    private String _frame;
    private String _rmType;

    private PIRemoveSystemConnection(PrintStream printStream, boolean bl) {
        this._out = printStream;
        this._writeStatus = bl;
        this._validParms = new HashMap(9, 0.5f);
        this._validParms.put("--ip", null);
        this._validParms.put("-m", null);
        this._validParms.put("-o", null);
        this._validParms.put("-e", null);
    }

    public HashMap getValidParms() {
        return this._validParms;
    }

    private short rmTypeToShort(String string) {
        int n = 1;
        if ("reset".equals(string)) {
            n = 1;
        } else if ("remove".equals(string)) {
            n = 2;
        } else if ("forceRemove".equals(string)) {
            n = 3;
        }
        return (short)n;
    }

    private String mapToFrameMTMS() {
        String string = this._frame;
        String string2 = null;
        if (string == null) {
            return null;
        }
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            CIMObjectPath cIMObjectPath;
            CIMValue cIMValue;
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_Frame", "root/ibmhscS1_0");
            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Frame"));
            Enumeration enumeration = PIHscUtil.getCIMEnumInstances(string2, cIMObjectPath2, true);
            String string3 = null;
            while (enumeration != null && enumeration.hasMoreElements() && !this._frame.equals(string3 = (String)(cIMValue = PIHscUtil.getCIMAttribute(string2, cIMObjectPath = (CIMObjectPath)enumeration.nextElement(), "Name")).getValue())) {
                cIMValue = PIHscUtil.getCIMAttribute(string2, cIMObjectPath, "UserDefinedName");
                String string4 = (String)cIMValue.getValue();
                if (!this._frame.equals(string4)) continue;
                string = string3;
                break;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
        return string;
    }

    private String mapToMTMS() {
        String string = this._managedSystem;
        String string2 = null;
        if (string == null) {
            return null;
        }
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            CIMObjectPath cIMObjectPath;
            CIMValue cIMValue;
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscS1_0");
            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            Enumeration enumeration = PIHscUtil.getCIMEnumInstances(string2, cIMObjectPath2, true);
            String string3 = null;
            while (enumeration != null && enumeration.hasMoreElements() && !this._managedSystem.equals(string3 = (String)(cIMValue = PIHscUtil.getCIMAttribute(string2, cIMObjectPath = (CIMObjectPath)enumeration.nextElement(), "Name")).getValue())) {
                cIMValue = PIHscUtil.getCIMAttribute(string2, cIMObjectPath, "UserDefinedName");
                String string4 = (String)cIMValue.getValue();
                if (!this._managedSystem.equals(string4)) continue;
                string = string3;
                break;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
        return string;
    }

    private void doRemoveConnection() {
        HSCSendSignalClt hSCSendSignalClt = HSCSendSignalClt.getInstance(null, null);
        int n = 204;
        Object var3_3 = null;
        if (this._managedSystem != null) {
            this._managedSystem = this.mapToMTMS();
        }
        if (this._frame != null) {
            this._frame = this.mapToFrameMTMS();
        }
        Vector<String> vector = new Vector<String>(3);
        if (this._managedSystem != null) {
            vector.addElement(this._managedSystem);
        } else if (this._frame != null) {
            vector.addElement(this._frame);
        } else {
            vector.addElement("$$Not$$Set$$");
        }
        vector.addElement("" + this.rmTypeToShort(this._rmType));
        if (this._ipAddress != null) {
            vector.addElement(this._ipAddress);
        } else {
            vector.addElement("$$Not$$Set$$");
        }
        String string = HscPasswordMgr.getHscUser();
        String string2 = HscPasswordMgr.getCredentialKey(string);
        try {
            hSCSendSignalClt.sendSignal(n, vector, string, string2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
    }

    private void performCommand() throws PIHscClientException {
        this.checkParameters();
        this.doRemoveConnection();
        if (this._writeStatus) {
            this._writeStatus = false;
            this._out.print('\u0000');
        }
    }

    private boolean validRmType(String string) {
        boolean bl = false;
        if (string == null) {
            bl = false;
        } else if ("reset".equals(string) || "remove".equals(string) || "forceRemove".equals(string)) {
            bl = true;
        }
        return bl;
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (!(this._managedSystem != null && this._managedSystem.length() >= 1 || this._ipAddress != null && this._ipAddress.length() >= 1 || this._frame != null && this._frame.length() >= 1)) {
            string = string + ", -m | --ip | -e";
        }
        if (this._rmType == null || !this.validRmType(this._rmType)) {
            string = string + ", -o";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this._managedSystem != null && this._ipAddress != null) {
            string = "[-m | --ip]";
        }
        if (this._frame != null && this._ipAddress != null) {
            string = "[-e | --ip]";
        }
        if (string.length() > 0) {
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
        }
    }

    private void mapParameters(HashMap hashMap) {
        this._ipAddress = (String)hashMap.get("--ip");
        this._rmType = (String)hashMap.get("-o");
        this._managedSystem = (String)hashMap.get("-m");
        this._frame = (String)hashMap.get("-e");
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "RMSYSCONN_HELP_GA3"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PIRemoveSystemConnection pIRemoveSystemConnection = new PIRemoveSystemConnection(printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pIRemoveSystemConnection.getValidParms());
            pIRemoveSystemConnection.mapParameters(hashMap);
            pIRemoveSystemConnection.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

